---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 21
  claims_with_evidence: 20
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：14-Firebase Game Loopベンチマーク画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：20 / 21、根拠なし：1
- 優先レビュー（高）
  1. **シナリオ番号の範囲（0-9）**：com.google.test.loops=10から推定した値であり、ネイティブ側の実際の制約は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/lite/tools/benchmark/experimental/firebase/android/src/org/tensorflow/lite/benchmark/firebase/BenchmarkModelActivity.java` (74行)
- E-02: `tensorflow/lite/tools/benchmark/experimental/firebase/android/src/org/tensorflow/lite/benchmark/firebase/BenchmarkModel.java` (34行)
- E-03: `tensorflow/lite/tools/benchmark/experimental/firebase/android/AndroidManifest.xml` (51行)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (15行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (43-44行目)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` (76-99行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UIなしのActivity（Theme.NoDisplay） | E-03 (39行目 `android:theme="@android:style/Theme.NoDisplay"`) | ○ |
| C-02 | noHistory=trueが設定 | E-03 (41行目 `android:noHistory="true"`) | ○ |
| C-03 | TEST_LOOPアクションのIntent Filterを持つ | E-03 (44行目 `com.google.intent.action.TEST_LOOP`) | ○ |
| C-04 | application/javascript mimeTypeが指定 | E-03 (46行目 `android:mimeType="application/javascript"`) | ○ |
| C-05 | com.google.test.loops=10（10シナリオ） | E-03 (32-33行目) | ○ |
| C-06 | TEST_LOOP以外のIntentで即finish() | E-01 (42-45行目) | ○ |
| C-07 | scenario番号をgetIntExtra()で取得（デフォルト0） | E-01 (46行目) | ○ |
| C-08 | intent.getData()でレポートファイルURIを取得 | E-01 (50行目) | ○ |
| C-09 | ContentResolverでレポートファイルを書き込みモード("w")で開く | E-01 (54-55行目) | ○ |
| C-10 | ParcelFileDescriptorからファイルディスクリプタ取得 | E-01 (55行目) | ○ |
| C-11 | BenchmarkModel.run(this, scenario, reportFd)の3引数呼び出し | E-01 (62行目) | ○ |
| C-12 | reportFdはParcelFileDescriptorがnullの場合-1 | E-01 (61行目) | ○ |
| C-13 | FileNotFoundException/NullPointerExceptionのキャッチ | E-01 (56行目) | ○ |
| C-14 | close()失敗時のIOExceptionキャッチ | E-01 (67行目) | ○ |
| C-15 | tensorflowlite_benchmark_firebaseネイティブライブラリをロード | E-02 (23行目) | ○ |
| C-16 | run()でnativeLibraryDirを内部解決 | E-02 (29行目) | ○ |
| C-17 | nativeRun(libraryDir, scenario, reportFd)のJNI呼び出し | E-02 (30行目, 33行目) | ○ |
| C-18 | READ/WRITE_EXTERNAL_STORAGE権限が必要 | E-03 (22-23行目) | ○ |
| C-19 | minSdkVersion=23、targetSdkVersion=23 | E-03 (26-27行目) | ○ |
| C-20 | 関連機能No.81が主機能、No.82が補助機能 | E-05 (43-44行目) | ○ |
| C-21 | シナリオ番号の範囲が0-9 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-21のシナリオ番号範囲は、AndroidManifest.xmlのcom.google.test.loops=10から推定したものである。ネイティブ層でのシナリオ番号の実際の制約やマッピングについてはソースコードからは確認できない
  - 候補：ネイティブC++コード / Firebase Test Labドキュメント / ベンチマークシナリオ設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ActivityのIntent処理とBenchmarkModel呼び出しフローは正確に記述されている
- 1: 中リスク - ネイティブ層のシナリオ実装詳細は本設計書のスコープ外であるが、利用者にとって重要な情報である可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] BenchmarkModelActivity.javaのonCreateメソッドの処理フローが設計書と一致しているか
- [ ] TEST_LOOPアクション検証とエラーハンドリングが正確か
- [ ] レポートファイルのオープン・クローズ処理とエラーハンドリングが正確か
- [ ] BenchmarkModel.javaのネイティブライブラリ名と引数が正確か
- [ ] AndroidManifest.xmlのIntent Filter定義とメタデータが正確か
- [ ] No.11のBenchmarkModelActivityとの差異が明確に記述されているか
